/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import jclass.base.Border;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.bwt.SpinArrowButton;
import jclass.bwt.SpinBoxConverter;
import jclass.bwt.SpinField;
import jclass.util.JCVector;

public class JCSpinBox
extends JCContainer
implements JCTextInterface,
JCActionListener {
    protected SpinField text;
    protected SpinArrowButton decr_arrow;
    protected SpinArrowButton incr_arrow;
    protected int position;
    protected int min;
    protected int max = Integer.MAX_VALUE;
    protected int incr = 1;
    protected int decimals;
    protected Object value;
    protected boolean auto_arrow_disable = true;
    protected int border = 2;
    protected static final int NONE = 0;
    protected static final int INCREMENT = 1;
    protected static final int DECREMENT = -1;
    static final int BEGIN = 0;
    static final int END = 1;
    private int pow = (int)Math.pow(10.0, this.decimals);
    private char decimal_point_char;
    protected JCVector listeners = new JCVector(0);
    private static final String base = "spinbox";
    private static int nameCounter;

    public JCSpinBox() {
        this(null, null);
    }

    public JCSpinBox(int n) {
        this(null, null);
        this.text.setColumns(n);
    }

    public JCSpinBox(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        if (this.getClass().getName().equals("jclass.bwt.JCSpinBox")) {
            this.getParameters(applet);
        }
        this.setLayout(null);
        this.text = new SpinField(this);
        this.add(this.text);
        this.incr_arrow = new SpinArrowButton(10, this);
        this.add(this.incr_arrow);
        this.decr_arrow = new SpinArrowButton(9, this);
        this.add(this.decr_arrow);
        this.decr_arrow.initial_delay = 250;
        this.incr_arrow.initial_delay = 250;
        this.text.addActionListener(this);
        this.incr_arrow.setTraversable(false);
        this.decr_arrow.setTraversable(false);
        this.text.setBorderThickness(0);
        this.incr_arrow.addActionListener(this);
        this.decr_arrow.addActionListener(this);
        this.initTextValue();
    }

    protected void getParameters() {
        super.getParameters();
        SpinBoxConverter.getParams(this);
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public JCArrowButton getDecrementArrow() {
        return this.decr_arrow;
    }

    public JCArrowButton getIncrementArrow() {
        return this.incr_arrow;
    }

    public boolean getAutoArrowDisable() {
        return this.auto_arrow_disable;
    }

    public void setAutoArrowDisable(boolean bl) {
        this.auto_arrow_disable = bl;
        this.enableArrowButtons();
    }

    public int getDecimalPlaces() {
        return this.decimals;
    }

    public void setDecimalPlaces(int n) {
        this.decimals = n;
        this.pow = (int)Math.pow(10.0, n);
        this.setTextValue(this.value);
    }

    public int getIncrement() {
        return this.incr;
    }

    public void setIncrement(int n) {
        this.incr = n;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.validate(this.value);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
        this.validate(this.value);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
        this.value = new Integer((this.position - this.min) / this.incr + this.min);
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    public int getIntValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return Integer.parseInt(this.text.getText());
    }

    public void setIntValue(int n) {
        this.value = new Integer(n);
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    public String getValue() {
        return this.text.getText();
    }

    public synchronized void setText(String string) {
        if (string == null || string.length() == 0) {
            this.setIntValue(this.min);
            return;
        }
        this.setTextValue(string);
        this.enableArrowButtons();
    }

    public synchronized String getText() {
        return this.text.getText();
    }

    public void addSpinBoxListener(JCSpinBoxListener jCSpinBoxListener) {
        this.listeners.addUnique(jCSpinBoxListener);
    }

    public void removeSpinBoxListener(JCSpinBoxListener jCSpinBoxListener) {
        this.listeners.removeElement(jCSpinBoxListener);
    }

    protected int preferredWidth() {
        return JCComponent.getPreferredSize((Component)this.text).width + JCComponent.getPreferredSize((Component)this.incr_arrow).width + 2 * this.border;
    }

    protected int preferredHeight() {
        return 2 * this.border + JCComponent.getPreferredSize((Component)this.text).height;
    }

    public synchronized void layout() {
        int n = JCComponent.getPreferredSize((Component)this.text).height;
        int n2 = n / 2;
        int n3 = JCComponent.getPreferredSize((Component)this.incr_arrow).width;
        int n4 = this.size().width - n3 - this.border;
        int n5 = n % 2;
        JCComponent.setBounds(this.text, this.border, this.border, this.size().width - n3 - 2 * this.border, n2 * 2);
        JCComponent.setBounds(this.incr_arrow, n4, this.border, n3, n2);
        JCComponent.setBounds(this.decr_arrow, n4, n2 + this.border, n3, n2 + n5);
        this.enableArrowButtons();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.decr_arrow.setBackground(color);
        this.incr_arrow.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.decr_arrow.setForeground(color);
        this.incr_arrow.setForeground(color);
    }

    public void paintInterior(Graphics graphics) {
        graphics.clearRect(0, 0, this.size().width, this.size().height);
        Border.draw(graphics, 3, this.border, 0, 0, this.size().width, this.size().height, this.getBackground(), this.getForeground());
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.removeKeyListener(keyListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.removeFocusListener(focusListener);
        }
    }

    public String getSelectedText() {
        return this.text.getSelectedText();
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
    }

    public int getSelectionStart() {
        return this.text.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.text.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.text.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.text.setSelectionEnd(n);
    }

    public void select(int n, int n2) {
        this.text.select(n, n2);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void insert(String string, int n) {
        this.text.insert(string, n);
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void replaceRange(String string, int n, int n2) {
        this.text.replaceRange(string, n, n2);
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public void setColumns(int n) {
        this.text.setColumns(n);
    }

    public int getAlignment() {
        return this.text.getAlignment();
    }

    public void setAlignment(int n) {
        this.text.setAlignment(n);
    }

    public int getMaximumLength() {
        return this.text.getMaximumLength();
    }

    public void setMaximumLength(int n) {
        this.text.setMaximumLength(n);
    }

    public int getStringCase() {
        return this.text.getStringCase();
    }

    public void setStringCase(int n) {
        this.text.setStringCase(n);
    }

    public void beep() {
        this.text.beep();
    }

    public boolean getChanged() {
        return this.text.getChanged();
    }

    public void setChanged(boolean bl) {
        this.text.setChanged(bl);
    }

    public Dimension getMinimumSize(int n) {
        return this.text.getMinimumSize(n);
    }

    public int[] getSelectionList() {
        return this.text.getSelectionList();
    }

    public void setSelectionList(int[] nArray) {
        this.text.setSelectionList(nArray);
    }

    public Color getSelectedBackground() {
        return this.text.getSelectedBackground();
    }

    public void setSelectedBackground(Color color) {
        this.text.setSelectedBackground(color);
    }

    public Color getSelectedForeground() {
        return this.text.getSelectedForeground();
    }

    public void setSelectedForeground(Color color) {
        this.text.setSelectedForeground(color);
    }

    public int pointToPosition(int n, int n2) {
        return this.text.pointToPosition(n, n2);
    }

    public void showPosition(int n) {
        this.text.showPosition(n);
    }

    public int getCursorPosition() {
        return this.text.getCursorPosition();
    }

    public void setCursorPosition(int n) {
        this.text.setCursorPosition(n);
    }

    public void setOverstrike(boolean bl) {
        this.text.setOverstrike(bl);
    }

    public boolean getOverstrike() {
        return this.text.getOverstrike();
    }

    public int getLastPosition() {
        return this.text.getLastPosition();
    }

    public boolean getShowCursorPosition() {
        return this.text.getShowCursorPosition();
    }

    public void setShowCursorPosition(boolean bl) {
        this.text.setShowCursorPosition(bl);
    }

    public void addTextListener(JCTextListener jCTextListener) {
        this.text.addTextListener(jCTextListener);
    }

    public void removeTextListener(JCTextListener jCTextListener) {
        this.text.removeTextListener(jCTextListener);
    }

    public void addTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.addTextCursorListener(jCTextCursorListener);
    }

    public void removeTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.removeTextCursorListener(jCTextCursorListener);
    }

    public int getShadowThickness() {
        return this.text.getBorderThickness();
    }

    public void setShadowThickness(int n) {
        this.text.setBorderThickness(n);
    }

    public int getHighlightThickness() {
        return this.text.getHighlightThickness();
    }

    public void setHighlightThickness(int n) {
        this.text.setHighlightThickness(n);
    }

    public Color getHighlightColor() {
        return this.text.getHighlightColor();
    }

    public void setHighlightColor(Color color) {
        this.text.setHighlightColor(color);
    }

    protected JCSpinBoxEvent postSpinBoxEvent(int n, Object object) {
        if (this.listeners.size() == 0) {
            return null;
        }
        JCSpinBoxEvent jCSpinBoxEvent = new JCSpinBoxEvent(this, this.position, object);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            JCSpinBoxListener jCSpinBoxListener = (JCSpinBoxListener)this.listeners.elementAt(n2);
            if (n == 0) {
                jCSpinBoxListener.spinBoxChangeBegin(jCSpinBoxEvent);
            } else {
                jCSpinBoxListener.spinBoxChangeEnd(jCSpinBoxEvent);
            }
            ++n2;
        }
        return jCSpinBoxEvent;
    }

    protected char getDecimalPointChar() {
        if (this.decimal_point_char != '\u0000') {
            return this.decimal_point_char;
        }
        this.decimal_point_char = new Double(5.5).toString().charAt(1);
        return this.decimal_point_char;
    }

    protected Object calcValue(int n) {
        int n2;
        int n3 = n == 0 ? 0 : (n2 = n == 1 ? this.incr : -this.incr);
        if (this.value == null) {
            this.value = new Integer(this.min);
        }
        int n4 = (Integer)this.value + n2;
        n4 = Math.max(Math.min(n4, this.max), this.min);
        this.position = (n4 - this.min) / this.incr;
        return new Integer(n4);
    }

    protected void initTextValue() {
        this.value = new Integer(this.min);
        this.position = 0;
        this.setTextValue(this.value);
    }

    protected void setTextValue(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : null;
        if (this.decimals > 0) {
            string = new Double(((Integer)object).doubleValue() / (double)this.pow).toString();
            int n = string.indexOf(this.getDecimalPointChar());
            if (n == -1) {
                string = String.valueOf(string) + this.getDecimalPointChar();
                n = string.length() - 1;
            }
            int n2 = string.length() - n - 1;
            while (n2 < this.decimals) {
                string = String.valueOf(string) + '0';
                ++n2;
            }
        }
        this.text.setText(string);
        this.postSpinBoxEvent(1, object);
    }

    public void setTextAction(int n) {
        if (this.text.getChanged() && !this.validate(this.text.getText())) {
            this.text.beep();
            return;
        }
        Object object = this.calcValue(n);
        JCSpinBoxEvent jCSpinBoxEvent = this.postSpinBoxEvent(0, object);
        if (jCSpinBoxEvent != null) {
            if (!jCSpinBoxEvent.doit) {
                return;
            }
            if (object != jCSpinBoxEvent.value && !this.validate(jCSpinBoxEvent.value)) {
                return;
            }
            object = jCSpinBoxEvent.value;
        }
        this.value = object;
        this.setTextValue(this.value);
        this.enableArrowButtons();
    }

    protected void enableArrowButtons() {
        if (!this.auto_arrow_disable) {
            this.incr_arrow.enable(true);
            this.decr_arrow.enable(true);
            return;
        }
        int n = (Integer)this.value;
        this.incr_arrow.enable(n < this.max);
        this.decr_arrow.enable(n > this.min);
    }

    protected boolean validateKey(char c) {
        if (this.decimals == 0) {
            return Character.isDigit(c) || c == '-' && this.text.getText().indexOf(45) == -1;
        }
        return Character.isDigit(c) || c == '.' && this.text.getText().indexOf(46) == -1 || c == '-' && this.text.getText().indexOf(45) == -1;
    }

    protected boolean validate(Object object) {
        double d;
        boolean bl = false;
        char c = this.getDecimalPointChar();
        if (object instanceof String) {
            String string = (String)object;
            try {
                int n;
                if (this.decimals == 0) {
                    n = Integer.parseInt(string);
                } else {
                    if (string.indexOf(c) == 0) {
                        string = String.valueOf(string) + '.';
                    }
                    double d2 = Double.valueOf(string);
                    n = (int)Math.ceil(d2 * (double)this.pow);
                }
                if (bl = n >= this.min && n <= this.max) {
                    this.position = (n - this.min) / this.incr;
                    this.value = new Integer(n);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            bl = n >= this.min && n <= this.max;
            if (bl) {
                this.position = (n - this.min) / this.incr;
            }
        } else if (object instanceof Number && (bl = (d = ((Double)object).doubleValue()) >= (double)this.min && d <= (double)this.max)) {
            this.position = ((int)d - this.min) / this.incr;
        }
        return bl;
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.incr_arrow) {
            this.setTextAction(1);
            return;
        }
        if (jCActionEvent.getSource() == this.decr_arrow) {
            this.setTextAction(-1);
            return;
        }
        if (jCActionEvent.getSource() == this.text && this.text.getEditable()) {
            this.setTextAction(0);
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

